﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using Chapitre_8_Shared;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Xml.Serialization;
using System.Xml;

#if WINDOWS
using Microsoft.Xna.Framework.Content.Pipeline.Serialization.Intermediate;
#endif

namespace Chapitre_8
{
    public class Chapitre_8 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        KeyboardState keyboardState;
        KeyboardState lastKeyboardState;

        Map map;
        Cursor cursor;

        Vector2 mapSize = new Vector2(5, 5);

        StorageDevice device;
        StorageContainer container;
        
        public Chapitre_8()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferHeight = 160;
            graphics.PreferredBackBufferWidth = 160;

            this.Components.Add(new GamerServicesComponent(this));
        }

        protected override void Initialize()
        {
            base.Initialize();

            Guide.BeginShowStorageDeviceSelector(new AsyncCallback(GetDevice), null);
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
        }

        protected override void UnloadContent()
        {
        }

        protected override void Update(GameTime gameTime)
        {
            lastKeyboardState = keyboardState;
            keyboardState = Keyboard.GetState();

            if(keyboardState.IsKeyDown(Keys.C) && lastKeyboardState.IsKeyUp(Keys.C))
            {
                map = new Map();

                map = new Map(mapSize);

                for (int y = 0; y < map.Tiles.Length; y++)
                {
                    for (int x = 0; x < map.Tiles[0].Length; x++)
                    {
                        map.Tiles[y][x] = new Tile("grass", new Vector2(x, y));
                    }
                }

                map.LoadContent(Content);

                cursor = new Cursor();
                cursor.LoadContent(Content);
            }
            else if (keyboardState.IsKeyDown(Keys.S) && lastKeyboardState.IsKeyUp(Keys.S) && map != null)
            {
                // Sérialisation binaire
                //FileStream file;

                //if (!File.Exists(Path.Combine(container.Path, "test.sav")))
                //    file = File.Create(Path.Combine(container.Path, "test.sav"));
                //else
                //    file = File.Open(Path.Combine(container.Path, "test.sav"), FileMode.Truncate);

                //BinaryFormatter serializer = new BinaryFormatter();
                //serializer.Serialize(file, map);
                //file.Close();

                // Sérialisation XML
                //FileStream file;

                //if (!File.Exists(Path.Combine(container.Path, "test.xml")))
                //    file = File.Create(Path.Combine(container.Path, "test.xml"));
                //else
                //    file = File.Open(Path.Combine(container.Path, "test.xml"), FileMode.Truncate);

                //XmlSerializer serializer = new XmlSerializer(typeof(Map));
                //serializer.Serialize(file, map);
                //file.Close();

                XmlWriterSettings xmlSettings = new XmlWriterSettings();
                xmlSettings.Indent = true;

                using (XmlWriter xmlWritter = XmlWriter.Create("map.xml", xmlSettings))
                {
                    IntermediateSerializer.Serialize(xmlWritter, map, null);
                }
            }   
            else if (keyboardState.IsKeyDown(Keys.L) && lastKeyboardState.IsKeyUp(Keys.L))
            {
                // Désérialisation binaire
                //FileStream file = File.Open(Path.Combine(container.Path, "test.sav"), FileMode.Open);
                //BinaryFormatter serializer = new BinaryFormatter();
                //map = (Map)serializer.Deserialize(file);
                //file.Close();

                // Désérialisation XML
                //FileStream file = File.Open(Path.Combine(container.Path, "test.xml"), FileMode.OpenOrCreate);
                //XmlSerializer deserializer = new XmlSerializer(typeof(Map));
                //map = (Map)deserializer.Deserialize(file);
                //file.Close();

                map = Content.Load<Map>("map");

                map.LoadContent(Content);

                cursor = new Cursor();
                cursor.LoadContent(Content);
            }

            if (cursor != null && map != null)
            {
                cursor.Update(gameTime, mapSize);

                if (keyboardState.IsKeyDown(Keys.F1) && lastKeyboardState.IsKeyUp(Keys.F1))
                {
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].AssetName = "grass";
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].LoadContent(Content);
                }
                else if (keyboardState.IsKeyDown(Keys.F2) && lastKeyboardState.IsKeyUp(Keys.F2))
                {
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].AssetName = "tree";
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].LoadContent(Content);
                }
                else if (keyboardState.IsKeyDown(Keys.F3) && lastKeyboardState.IsKeyUp(Keys.F3))
                {
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].AssetName = "sand";
                    map.Tiles[(int)cursor.Position.Y][(int)cursor.Position.X].LoadContent(Content);
                }
            }
        }

        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            if (map != null)
                map.Draw(spriteBatch);

            if (cursor != null)
                cursor.Draw(spriteBatch);

            spriteBatch.End();
        }

        private void GetDevice(IAsyncResult result) 
        {
            if (result.IsCompleted)
            {
                try
                {
                    device = Guide.EndShowStorageDeviceSelector(result);
                    container = device.OpenContainer("Chapitre_8");
                }
                catch (Exception e)
                {
                    Guide.BeginShowMessageBox(PlayerIndex.One, "Erreur", e.Message, new string[] { "Ok" }, 0, MessageBoxIcon.Error, new AsyncCallback(EndShowMessageBox), null);
                }
            }
        }

        private void EndShowMessageBox(IAsyncResult result)
        {
            if (result.IsCompleted)
                Guide.EndShowMessageBox(result);
        }
    }
}
